/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.hmcservc;

import com.ibm.hwmca.base.hmcservc.HmcServicesErrorIds;
import com.ibm.hwmca.base.hmcservc.HmcServicesPlatform;
import com.ibm.hwmca.base.settings.network.FirewallAdmin;
import com.ibm.hwmca.base.settings.network.FirewallAdminException;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.interfaces.OpticalPAProvider;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.upgrddat.MigrateOS2Data;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class HmcServicesData
implements HmcServicesErrorIds,
MigrateOS2Data {
    private static final String TRACE_MASKT = "HSRVDATT";
    private static final String TRACE_MASKF = "HSRVDATF";
    private static final String TRACE_MASKD = "HSRVDATD";
    private static final String paFileName = "disable.pa";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-42, "HmcServcData");
    private static final String PERSIST_KEY = "com.ibm.hwmca.base.hmcservc.HmcServicesData";
    private static HmcServicesData instance = null;
    private HmcServicesPersistentData data = null;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Tower;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$interfaces$OpticalPAProvider;

    private HmcServicesData() {
        this.data = new HmcServicesPersistentData();
        this.data.remoteOperationEnabled = false;
        this.data.opticalEnabled = false;
        this.data.callAnsEnabled = false;
        this.data.licChangeEnabled = false;
    }

    private HmcServicesData(HmcServicesPersistentData data) {
        this.data = data;
    }

    public static HmcServicesData getHmcServicesData() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteOperationEnabled(boolean remoteOperationEnabled) {
        Trace.trace(TRACE_MASKT, "--> setRemoteOperationEnabled(" + remoteOperationEnabled + ")");
        HmcServicesPersistentData hmcServicesPersistentData = this.data;
        synchronized (hmcServicesPersistentData) {
            boolean wasEnabled = this.data.remoteOperationEnabled;
            this.data.remoteOperationEnabled = remoteOperationEnabled;
            this.persistData();
            Trace.trace(TRACE_MASKF, "setRemoteOperationEnabled: enabled=" + this.data.remoteOperationEnabled + " wasEnabled=" + wasEnabled);
            if (this.data.remoteOperationEnabled) {
                if (!wasEnabled) {
                    try {
                        Trace.trace(TRACE_MASKF, "setRemoteOperationEnabled: enabling web ports");
                        FirewallAdmin.getFirewallAdmin().enableWebPorts();
                    }
                    catch (FirewallAdminException e) {
                        Trace.trace(TRACE_MASKF, e);
                    }
                }
            } else if (wasEnabled) {
                try {
                    Trace.trace(TRACE_MASKF, "setRemoteOperationEnabled: disabling web ports");
                    FirewallAdmin.getFirewallAdmin().disableWebPorts();
                }
                catch (FirewallAdminException e) {
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<-- setRemoteOperationEnabled()");
    }

    public boolean isRemoteOperationEnabled() {
        Trace.trace(TRACE_MASKT, "<-> isRemoteOperationEnabled()");
        return this.data.remoteOperationEnabled;
    }

    public void setPaEnabled(boolean paEnabled) throws HException, IOException {
        Trace.trace(TRACE_MASKT, "--> setPaEnabled(" + paEnabled + ")");
        String pafilename = BaseFileControl.getFilePath(paFileName) + paFileName;
        File pafile = new File(pafilename);
        if (pafile.exists()) {
            if (paEnabled) {
                Trace.trace(TRACE_MASKF, "deleting file: [" + pafilename + "]");
                pafile.delete();
            }
        } else if (!paEnabled) {
            Trace.trace(TRACE_MASKF, "executing command: [touch " + pafilename + "]");
            Runtime.getRuntime().exec("touch " + pafilename);
        }
        byte[] simData = new byte[]{paEnabled ? (byte)1 : 0};
        SimServer.getSimServer().writeSim(91, simData);
        Trace.trace(TRACE_MASKT, "<-- setPaEnabled()");
    }

    public boolean isPaEnabled() throws HException {
        byte[] simData;
        Trace.trace(TRACE_MASKT, "-> isPaEnabled()");
        boolean enabled = true;
        String pafilename = BaseFileControl.getFilePath(paFileName) + paFileName;
        File pafile = new File(pafilename);
        if (pafile.exists()) {
            Trace.trace(TRACE_MASKF, "file [" + pafilename + "] exists.");
            enabled = false;
        } else {
            Trace.trace(TRACE_MASKF, "file [" + pafilename + "] does not exist.");
            enabled = true;
        }
        if (enabled && (simData = SimServer.getSimServer().readSim(91)) != null && simData[0] == 0) {
            enabled = false;
        }
        Trace.trace(TRACE_MASKT, "<- isPaEnabled(" + enabled + ")");
        return enabled;
    }

    public void setExclusiveEnabled(boolean enabled) {
        Trace.trace(TRACE_MASKT, "--> setExclusiveEnabled(" + enabled + ")");
        HmcServicesPlatform platform = new HmcServicesPlatform();
        platform.setExclusiveEnabled(enabled);
        Trace.trace(TRACE_MASKT, "<-- setExclusiveEnabled()");
    }

    public boolean isExclusiveEnabled() {
        Trace.trace(TRACE_MASKT, "-> isExclusiveEnabled()");
        HmcServicesPlatform platform = new HmcServicesPlatform();
        boolean enabled = platform.isExclusiveEnabled();
        Trace.trace(TRACE_MASKT, "<- isExclusiveEnabled(" + enabled + ")");
        return enabled;
    }

    public void setAutoSwitchEnabled(boolean enabled) throws HException {
        Trace.trace(TRACE_MASKT, "--> setAutoSwitchEnabled(" + enabled + ")");
        HmcServicesPlatform platform = new HmcServicesPlatform();
        platform.setAutoSwitchEnabled(enabled);
        Trace.trace(TRACE_MASKT, "<-- setAutoSwitchEnabled()");
    }

    public boolean isAutoSwitchEnabled() throws HException {
        Trace.trace(TRACE_MASKT, "-> isAutoSwitchEnabled()");
        HmcServicesPlatform platform = new HmcServicesPlatform();
        boolean enabled = platform.isAutoSwitchEnabled();
        Trace.trace(TRACE_MASKT, "<- isAutoSwitchEnabled(" + enabled + ")");
        return enabled;
    }

    public void setCbuEnabled(boolean enabled) throws HException {
        Trace.trace(TRACE_MASKT, "--> setCbuEnabled(" + enabled + ")");
        HmcServicesPlatform platform = new HmcServicesPlatform();
        platform.setCbuEnabled(enabled);
        Trace.trace(TRACE_MASKT, "<-- setCbuEnabled()");
    }

    public boolean isCbuEnabled() throws HException {
        Trace.trace(TRACE_MASKT, "-> isCbuEnabled()");
        HmcServicesPlatform platform = new HmcServicesPlatform();
        boolean enabled = platform.isCbuEnabled();
        Trace.trace(TRACE_MASKT, "<- isCbuEnabled(" + enabled + ")");
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpticalEnabled(boolean opticalEnabled) {
        Trace.trace(TRACE_MASKT, "--> setOpticalEnabled(" + opticalEnabled + ")");
        HmcServicesPersistentData hmcServicesPersistentData = this.data;
        synchronized (hmcServicesPersistentData) {
            this.data.opticalEnabled = opticalEnabled;
            this.persistData();
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            Set inventory = mom.getInventory(new ClassId(class$com$ibm$hwmca$fw$managed$Tower == null ? (class$com$ibm$hwmca$fw$managed$Tower = HmcServicesData.class$("com.ibm.hwmca.fw.managed.Tower")) : class$com$ibm$hwmca$fw$managed$Tower));
            Tower[] towerArray = inventory.toArray(new Tower[inventory.size()]);
            Trace.trace(TRACE_MASKD, "got " + towerArray.length + " towers to work with");
            for (int i = 0; i < towerArray.length; ++i) {
                Trace.trace(TRACE_MASKD, "get the optical impl");
                OpticalPAProvider optPro = (OpticalPAProvider)towerArray[i].getInterfaceImpl(class$com$ibm$hwmca$fw$interfaces$OpticalPAProvider == null ? HmcServicesData.class$("com.ibm.hwmca.fw.interfaces.OpticalPAProvider") : class$com$ibm$hwmca$fw$interfaces$OpticalPAProvider);
                if (optPro != null) {
                    try {
                        if (opticalEnabled) {
                            Trace.trace(TRACE_MASKD, "enable Optical PA");
                            optPro.enableOpticalPA();
                            Trace.trace(TRACE_MASKD, "done");
                            continue;
                        }
                        Trace.trace(TRACE_MASKD, "disable Optical PA");
                        optPro.disableOpticalPA();
                        Trace.trace(TRACE_MASKD, "done");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKD, "got an exception");
                        Trace.trace(TRACE_MASKD, e);
                        new FrameworkLog(logInfo, 8, e).log();
                    }
                    continue;
                }
                Trace.trace(TRACE_MASKD, "didn't have the interface");
            }
            Trace.trace(TRACE_MASKD, "done");
            Trace.trace(TRACE_MASKT, "<-- setOpticalEnabled()");
        }
    }

    public boolean isOpticalEnabled() {
        Trace.trace(TRACE_MASKT, "<-> isOpticalEnabled()");
        return this.data.opticalEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallAnsEnabled(boolean callAnsEnabled) {
        Trace.trace(TRACE_MASKT, "--> setCallAnsEnabled(" + callAnsEnabled + ")");
        HmcServicesPersistentData hmcServicesPersistentData = this.data;
        synchronized (hmcServicesPersistentData) {
            this.data.callAnsEnabled = callAnsEnabled;
            this.persistData();
        }
        Trace.trace(TRACE_MASKT, "<-- setCallAnsEnabled()");
    }

    public boolean isCallAnsEnabled() {
        Trace.trace(TRACE_MASKT, "<-> isCallAnsEnabled()");
        return this.data.callAnsEnabled;
    }

    private void persistData() {
        Trace.trace(TRACE_MASKT, "--> persistData()");
        try {
            PersistenceManager manager = PersistenceManager.getPersistenceManager();
            manager.write(PERSIST_KEY, this.data);
        }
        catch (Exception e) {
            new FrameworkLog(logInfo, 7, e).log();
        }
        Trace.trace(TRACE_MASKT, "<-- persistData()");
    }

    public void restoreOS2Data(Object os2Data, String simName) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> restoreOS2Data(" + os2Data + "," + simName + ")");
        byte[] data = (byte[])os2Data;
        if (simName.equals("XMRC_ROF_ENABLED")) {
            this.setRemoteOperationEnabled(data[0] != 0);
        } else if (simName.equals("XMRC_PA_FOCAL_POINT")) {
            this.setOpticalEnabled(data[0] != 0);
        } else if (simName.equals("XMRC_DLC_ACTIVE")) {
            this.setCallAnsEnabled(data[0] != 0);
        }
        Trace.trace(TRACE_MASKT, "<- restoreOS2Data()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            PersistenceManager pm = PersistenceManager.getPersistenceManager();
            instance = pm.contains(PERSIST_KEY) ? new HmcServicesData((HmcServicesPersistentData)pm.read(PERSIST_KEY)) : new HmcServicesData();
        }
        catch (Exception e) {
            instance = new HmcServicesData();
            new FrameworkLog(logInfo, 6, e).log();
        }
    }

    private static class HmcServicesPersistentData
    implements Persistable,
    PersistentData {
        private static final long serialVersionUID = 1L;
        public boolean remoteOperationEnabled;
        public boolean opticalEnabled;
        public boolean callAnsEnabled;
        public boolean licChangeEnabled;

        public HmcServicesPersistentData() {
        }

        public HmcServicesPersistentData(PersistentData data) {
            HmcServicesPersistentData newData = (HmcServicesPersistentData)data;
            this.remoteOperationEnabled = newData.remoteOperationEnabled;
            this.opticalEnabled = newData.opticalEnabled;
            this.callAnsEnabled = newData.callAnsEnabled;
            this.licChangeEnabled = newData.licChangeEnabled;
        }

        public PersistentData getPersistentData() {
            return this;
        }

        public boolean isUpgradeData() {
            return true;
        }

        public String toString() {
            return "remoteOperationEnabled: " + this.remoteOperationEnabled + "\n" + "opticalEnabled: " + this.opticalEnabled + "\n" + "callAnsEnabled: " + this.callAnsEnabled + "\n";
        }
    }
}

